<?php

namespace App\State;

use ApiPlatform\Metadata\Operation;
use ApiPlatform\State\ProviderInterface;
use App\Entity\DonneeVente;
use App\Entity\Vente;
use App\Repository\VenteRepository;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Persistence\ManagerRegistry;
use Doctrine\Persistence\ObjectRepository;

class DonneeVenteProvider implements ProviderInterface
{
    private ManagerRegistry $doctrine;
    private VenteRepository $ventes;

    public function __construct(ManagerRegistry $doctrine, VenteRepository $ventes)
    {
        $this->doctrine = $doctrine;

        assert($ventes != null);

        $this->ventes = $ventes;
    }

    public function provide(Operation $operation, array $uriVariables = [], array $context = []): object|array|null
    {
        $vente = $this->ventes->findOneBy([]);

        $res = new ArrayCollection();

        for($i = 0; $i<1; $i++) {
            $v = new DonneeVente();

            $date = new \DateTime(date("Y-m-d", strtotime('2021-01-01 + '.$i .' Days')));

            $v->setDate($vente->getDate());
            $v->setQuantite(69);

            $res[] = $v;
        }
        return $res;
    }
}
