import React, { useState, useEffect } from "react";
import Camembert from "../../components/Diagrammes/Camembert";
import { fetch } from "../../utils/dataAccess";
import { RegionVentes } from "../../types/RegionVentes";

const getRegionVentes = async () => {
  const data = await fetch("/ventes/regions");
  return JSON.parse(data.text);
}

export default function Home() {
  const [regionVentes, setRegionVentes] = useState<RegionVentes[] | undefined>(undefined);

  useEffect(() => {
    const fetchData = async () => {
      const data = await getRegionVentes();
      setRegionVentes(data);
    };
    fetchData();
  }, []);
  console.log(regionVentes);
  return (
  <div className="container">
  {regionVentes ? <Camembert  fetchedData={regionVentes} /> : 'Loading...'}
  </div>
  );
}