import React, { useEffect, RefObject } from 'react';
import * as d3 from 'd3';
import { isEmptyArray } from 'formik';
import { RegionVentes } from '../../types/RegionVentes';

type DataPoint = { label: string; value: number; };



const Camembert = (props : any) => {
  const ref: RefObject<HTMLDivElement> = React.createRef();
  let data : DataPoint[] = [];
  if (isEmptyArray(props.fetchedData) ){
    data = [
      { label: 'Auvergne-Rhône-Alpes', value: 4557 },
      { label: 'Bourgogne-Franche-Comté', value: 2556 },
      { label: 'Bretagne', value: 10555 },
      { label: 'Centre-Val de Loire', value: 7589 },
      { label: 'Corse', value: 8835 },
      { label: 'Grand Est', value: 1616 },
      { label: 'Hauts-de-France', value: 6111 },
      { label: 'Île-de-France', value: 6818 },
      { label: 'Normandie', value: 16168 },
      { label: 'Nouvelle-Aquitaine', value: 1318 },
      { label: 'Occitanie', value: 1368 },
      { label: 'Pays de la Loire', value: 5427 },
      { label: 'Provence-Alpes-Côte d\'Azur', value: 9632 },
    ];
  }else{
    let fetchedData = props.fetchedData["hydra:member"];
    console.log("fetched : " + JSON.stringify(props.fetchedData["hydra:member"].length));
    for (let index = 0; index < fetchedData.length; index++) {
      const element = {label : fetchedData[index].regionName, value : fetchedData[index].count};
      data.push(element);
    }
  }

  useEffect(() => {
    draw();
  });

  const draw = () => {
    const container = ref.current;
    if (!container) return;

    const width = 900;
    const height = 500;
    const radius = Math.min(width, height) / 2;

    const color = d3.scaleOrdinal(d3.schemeCategory10);

    const pie = d3.pie<DataPoint>()
      .sort(null)
      .value((d: DataPoint) => d.value);

    const arc = d3.arc<d3.PieArcDatum<DataPoint>>()
      .outerRadius(radius - radius/2)
      .innerRadius(radius);

    const labelArc = d3.arc<d3.PieArcDatum<DataPoint>>()
      .outerRadius(radius+20)
      .innerRadius(radius+20);

    const svg = d3.select(container)
      .append('svg')
      .attr('width', width)
      .attr('height', height)
      .append('g')
      .attr('transform', `translate(${width / 2},${height / 2})`);

    const g = svg.selectAll('.arc')
      .data(pie(data))
      .enter().append('g')
      .attr('class', 'arc');

    g.append('path')
      .attr('d', arc)
      .style('fill', (d: any) => color(d.data.label));
    
      g.append('text')
        .attr('transform', (d: any) => {
          // Calcul de l'angle moyen
          const midAngle = d.endAngle < Math.PI ? d.startAngle / 2 + d.endAngle / 2 : d.startAngle / 2 + d.endAngle / 2 + Math.PI;
          // Translation du label pour l'aligner horizontalement avec le diagramme
          return `translate(${labelArc.centroid(d)})`;
        })
        .attr('dy','.35em') 
        .style('text-anchor', (d: any) => {
          // Si l'angle moyen est supérieur à Math.PI, aligner le label à droite
          if (d.endAngle > Math.PI) return 'end';
          // Sinon, aligner le label à gauche
          return 'start';
        })
        .text((d: any) => d.data.label + " : " + d.data.value.valueOf());

    
    };
  return (
    <div className="Camembert" ref={ref}>
    </div>
  );
};

export default Camembert;