<?php

namespace App\State;

use ApiPlatform\Metadata\Operation;
use ApiPlatform\State\ProviderInterface;
use App\Entity\RegionVentes;
use App\Repository\VenteRepository;
use Doctrine\Common\Collections\ArrayCollection;

class RegionVentesProvider implements ProviderInterface
{
    private VenteRepository $repository;

    private array $regions = [
        RegionVentes::AUVERGNE_RHONE_ALPES => ['03', '63', '15', '42', '43', '69', '07', '01', '38', '26', '74', '73'],
        RegionVentes::BOURGOGNE_FRANCHE_COMTE => ['89', '58', '21', '71', '70', '25', '39', '90'],
        RegionVentes::BRETAGNE => ['29', '22', '56', '35'],
        RegionVentes::CENTRE_VAL_DE_LOIRE => ['28', '45', '41', '37', '36', '18'],
        RegionVentes::CORSE => ['2A', '2B'],
        RegionVentes::GRAND_EST => ['08', '51', '10', '55', '52', '54', '57', '88', '67', '68'],
        RegionVentes::HAUTS_DE_FRANCE => ['62', '59', '80', '60', '02'],
        RegionVentes::ILE_DE_FRANCE => ['95', '78', '91', '77', '92', '75', '93', '94'],
        RegionVentes::NORMANDIE => ['50', '14', '61', '76', '27'],
        RegionVentes::NOUVELLE_AQUITAINE => ['79', '86', '87', '23', '17', '16', '24', '19', '33', '47', '40', '64'],
        RegionVentes::OCCITANIE => ['65', '32', '31', '82', '46', '09', '81', '12', '48', '30', '34', '11', '66'],
        RegionVentes::PAYS_DE_LA_LOIRE => ['53', '72', '49', '44', '85'],
        RegionVentes::PROVENCE_ALPES_COTE_AZUR => ['05', '04', '06', '84', '83', '13'],
    ];

    public function __construct(VenteRepository $ventes)
    {
        $this->repository = $ventes;
    }

    public function provide(Operation $operation, array $uriVariables = [], array $context = []): object|array|null
    {
        $tmp = [];
        $res = new ArrayCollection();

        foreach ($this->regions as $region => $departements) {
            $tmp[$region] = new RegionVentes();
            $tmp[$region]->setRegion($region);
        }

        $tmp[RegionVentes::OUTRE_MER] = new RegionVentes();
        $tmp[RegionVentes::OUTRE_MER]->setRegion(RegionVentes::OUTRE_MER);

        $result = $this->repository->createQueryBuilder('v')
            ->select('v.departement as dept, COUNT(v) as nb')
            ->groupBy('dept')
            ->orderBy('dept')
            ->getQuery()->getResult();

        foreach ($result as $row) {
            $rv = new RegionVentes();

            $r = RegionVentes::OUTRE_MER;

            foreach ($this->regions as $region => $departements) {
                if (in_array($row['dept'], $departements)) {
                    $r = $region;
                    break;
                }
            }

            $tmp[$r]->addCount(intval($row['nb']));
        }

        foreach ($tmp as $region => $rv) {
            $res[] = $rv;
        }

        return $res;
    }
}
