<?php

namespace App\State;

use ApiPlatform\Metadata\Operation;
use ApiPlatform\State\ProviderInterface;
use App\Entity\NombreVentes;
use App\Repository\VenteRepository;
use DateTime;
use Doctrine\Common\Collections\ArrayCollection;

class NombreVentesProvider implements ProviderInterface
{
    private VenteRepository $repository;

    public function __construct(VenteRepository $ventes)
    {
        $this->repository = $ventes;
    }

    public function provide(Operation $operation, array $uriVariables = [], array $context = []): object|array|null
    {
        $res = new ArrayCollection();

        $qb = $this->repository->createQueryBuilder('v')
            ->where('v.date >= :start_date')
            ->andWhere('v.date <= :end_date')
            ->select('COUNT(v.id) as nb');

        switch ($context['granularite']) {
            case 'jour':
                $qb = $qb
                    ->addSelect('DAY(v.date) as jour')
                    ->addGroupBy('jour');
            case 'mois':
                $qb = $qb
                    ->addSelect('MONTH(v.date) as mois')
                    ->addGroupBy('mois');
            case 'annee':
                $qb = $qb
                    ->addSelect('YEAR(v.date) as annee')
                    ->addGroupBy('annee');
                break;
        }

        $qb = $qb
            ->setParameter('start_date', $context['dateDebut'])
            ->setParameter('end_date', $context['dateFin']);

        $result = $qb->getQuery()->getResult();

        foreach ($result as $row) {
            $v = new NombreVentes();

            $annee = 2022;
            $mois = 1;
            $jour = 1;

            $d = (new DateTime())->setTime(0, 0);

            if (array_key_exists('annee', $row)) {
                $annee = intval($row['annee']);
            }

            if (array_key_exists('mois', $row)) {
                $mois = intval($row['mois']);
            }

            if (array_key_exists('jour', $row)) {
                $jour = intval($row['jour']);
            }

            $d->setDate($annee, $mois, $jour);

            $v->setDate($d);
            $v->setQuantite(intval($row['nb']));

            $res[] = $v;
        }

        return $res;
    }
}
