<?php

namespace App\Entity;

use ApiPlatform\Action\NotFoundAction;
use ApiPlatform\Metadata\ApiFilter;
use ApiPlatform\Metadata\ApiProperty;
use ApiPlatform\Metadata\ApiResource;
use ApiPlatform\Metadata\Get;
use ApiPlatform\Metadata\GetCollection;
use ApiPlatform\Metadata\GraphQl\QueryCollection;
use App\Filter\DateRangeFilter;
use App\State\NombreVentesProvider;
use DateTimeInterface;
use Symfony\Component\Serializer\Annotation\Groups;

#[ApiResource (operations: [
    new GetCollection(
        uriTemplate: "/ventes/nombre",
        description: "Obtient le nombre de ventes en fonction de la date",
        provider: NombreVentesProvider::class
    ),
    new Get(
        uriTemplate: '/ventes/nombre/{dateString}',
        controller: NotFoundAction::class,
        output: false,
        read: false
    )
],
    normalizationContext: ['groups' => ['read']],
    paginationEnabled: false,
    graphQlOperations: [
        new QueryCollection(
            provider: NombreVentesProvider::class
        ),
    ]
)]
#[ApiFilter(DateRangeFilter::class)]
class NombreVentes
{
    private ?DateTimeInterface $date = null;

    private ?int $quantite = null;


    #[Groups('read')]
    public function getDate(): ?DateTimeInterface
    {
        return $this->date;
    }

    public function setDate(DateTimeInterface $date): self
    {
        $this->date = $date;

        return $this;
    }

    #[Groups('read')]
    public function getQuantite(): ?int
    {
        return $this->quantite;
    }

    public function setQuantite(int $quantite): self
    {
        $this->quantite = $quantite;

        return $this;
    }

    #[ApiProperty(identifier: true)]
    public function getDateString(): string
    {
        return $this->date->format('Y-m-d');
    }
}
