<?php

namespace App\Entity;

use ApiPlatform\Action\NotFoundAction;
use ApiPlatform\Doctrine\Orm\Filter\DateFilter;
use ApiPlatform\Metadata\ApiFilter;
use ApiPlatform\Metadata\ApiProperty;
use ApiPlatform\Metadata\ApiResource;
use ApiPlatform\Metadata\Get;
use ApiPlatform\Metadata\GetCollection;
use ApiPlatform\Metadata\GraphQl\QueryCollection;
use App\State\PrixMoyenProvider;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\Serializer\Annotation\Groups;

#[ApiResource(operations: [
    new GetCollection(
        uriTemplate: "/ventes/prix",
        description: "Obtient le prix moyen au mètre carré en fonction du temps",
        name: "all",
        provider: PrixMoyenProvider::class
    ),
    new Get(
        uriTemplate: "/ventes/prix/{dateString}",
        controller: NotFoundAction::class,
        output: false,
        read: false,
    )
],
    normalizationContext: ['groups' => ['read']],
    paginationEnabled: false,
    graphQlOperations: [
        new QueryCollection(
            name:"all", provider: PrixMoyenProvider::class
        )
    ]
)]
class PrixMoyen
{
    private ?\DateTimeInterface $date = null;

    private ?float $prix = null;


    private string $someText = "";

    #[Groups('read')]
    public function getDate(): ?\DateTimeInterface
    {
        return $this->date;
    }

    public function setDate(\DateTimeInterface $date): self
    {
        $this->date = $date;

        return $this;
    }

    #[Groups('read')]
    public function getPrix(): ?float
    {
        return $this->prix;
    }

    public function setPrix(float $prix): self
    {
        $this->prix = $prix;

        return $this;
    }

    #[ApiProperty(identifier: true)]
    public function getDateString(): string
    {
        return $this->date->format('Y-m');
    }

    public function getSomeText(): ?string
    {
        return $this->someText;
    }

    public function setSomeText(string $text): self
    {
        $this->someText = $text;

        return $this;
    }
}
