<?php

namespace App\Entity;

use ApiPlatform\Metadata\ApiResource;
use ApiPlatform\Metadata\Get;
use ApiPlatform\Metadata\GetCollection;
use ApiPlatform\Metadata\GraphQl\Mutation;
use ApiPlatform\Metadata\GraphQl\Query;
use ApiPlatform\Metadata\GraphQl\QueryCollection;
use App\Repository\DonneeVenteRepository;
use App\Resolver\DonneeVenteResolver;
use App\State\DonneeVenteProvider;
use App\State\DonneeVenteRandomProvider;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

#[ApiResource (operations: [
    new GetCollection(
        uriTemplate: "/vente/nombre",
        description: "Returns the number of sales sorted by date",
        name: "Nombre",
        provider: DonneeVenteProvider::class
    ),
],
    paginationEnabled: false,
    graphQlOperations: [
        new QueryCollection(
            name: "Nombre", provider: DonneeVenteProvider::class
        ),
    ]
)]
class DonneeVente
{
    // TODO: voir pour passer en string? (2022-02-03, 2022-02, 2022)
    private ?\DateTimeInterface $date = null;

    private ?int $quantite = null;


    public function getDate(): ?\DateTimeInterface
    {
        return $this->date;
    }

    public function setDate(\DateTimeInterface $date): self
    {
        $this->date = $date;

        return $this;
    }

    public function getQuantite(): ?int
    {
        return $this->quantite;
    }

    public function setQuantite(int $quantite): self
    {
        $this->quantite = $quantite;

        return $this;
    }
}
