import styles from "../index.module.css";
import React, { useState, useEffect } from 'react';
import { Outlet, Link, useLoaderData } from "react-router-dom";
import mqtt from 'precompiled-mqtt';
export default function Root() {
  const [sensors, setSensors] = useState([]);
  const [brokerUrl, setBrokerUrl] = useState('');

  const topic = 'value/#';
  const client = mqtt.connect(brokerUrl);

  const [isConnected, setIsConnected] = useState(false);


  useEffect(() => {
    if(isConnected) {
      client.on('connect', () => {
        console.log(`Connected to MQTT broker ${brokerUrl}`);
        client.subscribe(topic, (err) => {
          if (err) {
            console.error('Error subscisConnectedribing to topic', err);
          } else {
            console.log(`Subscribed to topic ${topic}`);
          }
        });
      });

      client.on('message', (topic, message) => {
        const sensorData = JSON.parse(message.toString());
        setSensors((prevSensors) => {
          const existingSensor = prevSensors.find((sensor) => sensor.id === sensorData.id);
          if (existingSensor) {
            return prevSensors.map((sensor) => (sensor.id === sensorData.id ? sensorData : sensor));
          } else {
            return [...prevSensors, sensorData];
          }
        });
        console.log(`Received sensor data from topic ${topic}:`, sensorData);
      });
    }

  }, [brokerUrl], isConnected); // effect will run whenever brokerUrl changes

  const handleUrlChange = (e) => {
    const url = e.target.value;
    setBrokerUrl(url);
  };
  const handleDisconnect = () => {
    client.end();
    setIsConnected(false);
  };

  const handleConnect = () => {
    setIsConnected(true);
  };

  return (
    <>
      <div className={styles.wrapper}>
        <div className={styles.header}>
          <div className={styles.navbar}>
            <a href="">Real time sensors</a>
            <a href="">Other</a>
            <a href="">Foo</a>
          </div>
        </div>
        <div className={styles.sidebar}>
          <h1>Sensors</h1>
          <div className={styles.listSensors}>
            <nav>
            {sensors.length ? (
            <ul>
              {sensors.map((sensor) => (
                <li key={sensor.id}>
                  <Link to={`/${sensor.name}`}>
                    {sensor.name ? (
                      <>
                        {sensor.name}
                      </>
                    ) : (
                      <i>No Name</i>
                    )}{" "}
                  </Link>
                </li>
              ))}
            </ul>
          ) : (
            <p>
              <i>No sensors</i>
            </p>
          )}
            </nav>
          </div>
        </div>
        <div className={styles.divUrl}>
            <h4>URL : </h4>
            <input type="text" className={styles.urlInput} onChange={handleUrlChange} value={brokerUrl} />
          {isConnected ? (
              <button onClick={handleDisconnect}>Disconnect</button>
          ) : (
              <button onClick={handleConnect}>Connect</button>
          )}
        </div>
        <div className={styles.details}>
          <Outlet />
        </div>
      </div>
    </>
  );
}
