const express = require('express');
const crypto = require('crypto');
const redis = require('redis');

const app = express();
app.use(express.json());

// le client Redis
const client = redis.createClient({
    url: 'redis://redis:6379'
});

client.on('error', (err) => console.log('Erreur Redis Client', err));

// etablissement de la connexion Redis
async function connectRedis() {
    try {
        await client.connect();
    } catch (err) {
        console.error('Erreur de connexion Redis:', err);
        process.exit(1);
    }
}

connectRedis();

app.post('/calculate-md5', async (req, res) => {
    try {
        const text = req.body.text;
        const hash = crypto.createHash('md5').update(text).digest('hex');

        // on stocke le hash dans Redis avec la chaîne originale comme clé
        await client.set(text, hash);

        res.json({ text: text, hash: hash });
    } catch (err) {
        res.status(500).json({ error: 'Erreur du serveur' });
    }
});

app.get('/get-md5/:text', async (req, res) => {
    try {
        const text = req.params.text;

        //récupérer le hash de Redis
        const hash = await client.get(text);
        if (hash === null) {
            return res.status(404).json({ error: 'Texte non trouvé' });
        }
        res.json({ text: text, hash: hash });
    } catch (err) {
        res.status(500).json({ error: 'Erreur du serveur' });
    }
});

const PORT = 3000;
app.listen(PORT, () => {
    console.log(`Serveur démarré sur le port ${PORT}`);
});
