var mongoose = require('mongoose');
var Schema = mongoose.Schema;
var passportLocalMongoose = require('passport-local-mongoose');

var userSchema = new Schema({
    username: { type: String, required: true },
    password: { type: String},
    isAgent: { type: Boolean, default: false }
});

userSchema.plugin(passportLocalMongoose);

const announcementSchema = new Schema({
    title: { type: String, required: true },
    propertyType: {
        type: String,
        enum: ['À la vente', 'À la location'],
        required: true
    },
    publicationStatus: {
        type: String,
        enum: ['Publiée', 'Non publiée'],
        required: true
    },
    propertyStatus: {
        type: String,
        enum: ['Disponible', 'Loué', 'Vendu'],
        required: true
    },
    description: { type: String, required: true },
    price: { type:Number, required: true },
    availabilityDate: { type: Date, required: true },
    photos:{ type: [String] },
    userName: { type: String, required: true },
    questions: [
        {
            user: { type: String, required: true },
            question: { type: String, required: true },
            answers: [ { answer : { type: String } } ],
            date: { type: Date, default: Date.now }
        }
    ]
});

const User = mongoose.model('User', userSchema);
const Announcement = mongoose.model('Announcement', announcementSchema);

module.exports = {
    User: User,
    Announcement: Announcement
};

