var express = require('express');
var router = express.Router();
const passport = require('../passport-config');
const models = require("../schemas/models");

const User = models.User;

passport.use(User.createStrategy());

/* GET home page. */
router.get('/', function(req, res, next) {
    // res.render('login',{ user : req.user });
    res.redirect('/announcements');
});


router.get('/login', function(req, res, next) {
    if (req.isAuthenticated()) {
        return res.redirect('/announcements');
    }
    res.render('login', { user: req.user, messages: req.flash('error') });
});


router.post('/login',(req, res, next) => {
    passport.authenticate('local', (err, user, info) => {
        if (err) {
            return next(err);
        }
        if (!user) {
            return res.status(400).render('login', {error: 'Invalid username or password'});
        }
        req.logIn(user, (err) => {
            if (err) {
                return next(err);
            }
            return res.redirect('/announcements');
        });
    })(req, res, next);
});

router.get('/register', function(req, res) {
    res.render('register', { user : req.user });
});

router.post('/register', async function(req, res) {
    try {
        const { username, password, role } = req.body;
        const existingUser = await User.findOne({ username });

        if (existingUser) {
            return res.render('register', { error: ' This user already exists.' });
        }

        const isAgent = role === 'agent';

        User.register(new User ({ username : username, isAgent : isAgent}), password);
        //await newUser.setPassword(password);
        //await newUser.save();

        //passport.authenticate('local')(req, res, function () {
        res.redirect('/login');
        //});
    } catch (error) {
        res.render('register', { error: error.message });
    }
});

router.get('/logout', isAuthenticated, function(req, res, next) {
    req.logout(function(err) {
        if (err) {
            return next(err);
        }
        res.redirect('/');
    });
});

function isAuthenticated(req, res, next) {
    if (req.isAuthenticated()) {
        return next();
    }
    res.redirect('/login');
}
const setUserIfAuthenticated = (req, res, next) => {
    if (req.isAuthenticated()) {
        req.user = req.user;
    }
    next();
};

const isAgentAddAnnouncements = (req, res, next) => {
    if (req.user && req.user.isAgent) {
        return next();
    }
    req.flash('error', 'Vous n\'êtes pas autorisé à effectuer cette action. Créez un compte agent pour publier des annonces.');
    return next();
};

const isAgent = (req, res, next) => {
    if (req.user && req.user.isAgent) {
        return next();
    }
    return res.status(403).json({ message: 'Vous n\'êtes pas autorisé à effectuer cette action.' });
};

const isConsultant = (req, res, next) => {
    if (req.user && !req.user.isAgent) {
        return next();
    }
    return res.status(403).json({ message: 'Vous n\'êtes pas autorisé à effectuer cette action.' });
};

module.exports = {
    router: router,
    isAuthenticated: isAuthenticated,
    setUserIfAuthenticated:  setUserIfAuthenticated,
    isAgent: isAgent,
    isAgentAddAnnouncements: isAgentAddAnnouncements,
    isConsultant: isConsultant
};