const mongoose = require('mongoose');
require('dotenv').config();

const dbName = process.env.DB_NAME;
const url = `mongodb://172.18.0.2:27017/${dbName}`;

const connectToDatabase = async () => {
    try {
        await mongoose.connect(url, { useNewUrlParser: true, useUnifiedTopology: true });
        console.log(`Connecté à la base de données ${dbName}`);
    } catch (err) {
        console.error(err);
        throw err;
    }
};

module.exports = connectToDatabase;
