var mongoose = require('mongoose');
var Schema = mongoose.Schema;
var passportLocalMongoose = require('passport-local-mongoose');

var userSchema = new Schema({
    username: { type: String, required: true },
    password: { type: String, required: true },
    isAgent: { type: Boolean, default: false }
});

userSchema.plugin(passportLocalMongoose);

userSchema.methods.validPassword = function(password) {
    return this.password === password;
};

const User = mongoose.model('User', userSchema);
module.exports = User;

