var express = require('express');
var passport = require('passport');
const User = require('../schemas/models');
var router = express.Router();
const connectToDatabase = require('../database/connection');

router.get('/', function (req, res) {
  res.render('index', { user : req.user });
});

router.get('/register', function(req, res) {
  res.render('register', { });
});

router.post('/register', async function(req, res) {
  /*User.register(new User({ username : req.body.username }), req.body.password, function(err, account) {
          if (err) {
            return res.render('register', { account : account });
          }
      
          passport.authenticate('local')(req, res, function () {
            res.redirect('/');
          });
        });"*/
  try {
    const { username, password } = req.body;
    const existingUser = await User.findOne({ username });

    if (existingUser) {
      return res.render('register', { error: 'Cet utilisateur existe déjà.' });
    }

    const newUser = new User({
                    username: username,
                    password: password 
                  });
    await newUser.save();

    passport.authenticate('local')(req, res, function () {
      res.redirect('/');
    });
  } catch (error) {
    res.render('register', { error: error.message });
  }
});

router.get('/login', function(req, res) {
  res.render('login', { user : req.user });
});

router.post('/login', passport.authenticate('local'), function(req, res) {
  res.redirect('/');
});

router.get('/logout', function(req, res) {
  req.logout(function(err) {
    if (err) {
      return next(err);
    }
    res.redirect('/');
  });
});

router.get('/ping', function(req, res){
  res.status(200).send("pong!");
});

module.exports = router;
