var express = require('express');
var router = express.Router();
const passport = require('../passport-config');
const User = require('../schemas/models');

/* GET home page. */
router.get('/', function(req, res, next) {
    res.render('login',{ user : req.user });
});

router.get('/login', function(req, res, next) {
    res.render('login',{ user : req.user });
});

router.post('/login', function(req, res, next) {
    passport.authenticate('local', {
        successRedirect: '/dashboard',
        failureRedirect: '/'
    })(req, res, next);
});

router.get('/dashboard', isAuthenticated, function(req, res, next) {
    res.render('dashboard', { user: req.user });
});

router.get('/register', function(req, res) {
    res.render('register', { user : req.user });
});

router.post('/register', async function(req, res) {
    try {
        const { username, password, role } = req.body;
        const existingUser = await User.findOne({ username });

        if (existingUser) {
            return res.render('register', { error: ' This user already exists.' });
        }

        const newUser = new User({
            username: username,
            password: password,
            isAgent: role === 'agent'
        });

        await newUser.save();

        passport.authenticate('local')(req, res, function () {
            res.redirect('/');
        });
    } catch (error) {
        res.render('register', { error: error.message });
    }
});



router.get('/logout', isAuthenticated, function(req, res, next) {
    req.logout(function(err) {
        if (err) {
            return next(err);
        }
        res.redirect('/');
    });
});

function isAuthenticated(req, res, next) {
    if (req.isAuthenticated()) {
        return next();
    }
    res.redirect('/');
}

module.exports = router;