// dependencies
var createError = require('http-errors');
var express = require('express');
var path = require('path');
var cookieParser = require('cookie-parser');
var logger = require('morgan');

//var favicon = require('serve-favicon');
//var bodyParser = require('body-parser');
//var mongoose = require('mongoose');
//var LocalStrategy = require('passport-local').Strategy;

//var routes = require('./routes/index');
//var users = require('./routes/users');

const session = require('express-session');
const passport = require('./passport-config');
const connectToDatabase = require('./database/connection');

var indexRouter = require('./routes/index_');
var usersRouter = require('./routes/users');
var authentifcationRouter = require('./routes');

var app = express();

connectToDatabase();

// view engine setup
app.set('views', path.join(__dirname, 'views'));
app.set('view engine', 'pug');

// uncomment after placing your favicon in /public
//app.use(favicon(__dirname + '/public/favicon.ico'));
app.use(logger('dev'));
app.use(express.json());
app.use(express.urlencoded({ extended: false }));
//app.use(bodyParser.json());
//app.use(bodyParser.urlencoded({ extended: false }));
app.use(cookieParser());
app.use(express.static(path.join(__dirname, 'public')));
/*
app.use(require('express-session')({
  secret: 'keyboard cat',
  resave: false,
  saveUninitialized: false
}));
*/
//app.use(passport.initialize());
//app.use(passport.session());
//app.use(express.static(path.join(__dirname, 'public')));


//app.use('/', routes);

// passport config
//var Account = require('./models/account');
//passport.use(new LocalStrategy(Account.authenticate()));
//passport.serializeUser(Account.serializeUser());
//passport.deserializeUser(Account.deserializeUser());

// mongoose.Promise = global.Promise;
// mongoose
// mongoose.connect('mongodb://127.0.0.1:27017/AdsManagement');

app.use(session({ secret: 'fifiHajar', resave: true, saveUninitialized: true }));
app.use(passport.initialize());
app.use(passport.session());

//app.use('/', indexRouter);
app.use('/', authentifcationRouter);
app.use('/users', usersRouter);

// catch 404 and forward to error handler
app.use(function(req, res, next) {
  var err = new Error('Not Found');
  err.status = 404;
  next(err);
});

// catch 404 and forward to error handler
app.use(function(req, res, next) {
  next(createError(404));
});

// error handler
app.use(function(err, req, res, next) {
  // set locals, only providing error in development
  res.locals.message = err.message;
  res.locals.error = req.app.get('env') === 'development' ? err : {};

  // render the error page
  res.status(err.status || 500);
  res.render('error');
});

/*
// error handlers

// development error handler
// will print stacktrace
if (app.get('env') === 'development') {
  app.use(function(err, req, res, next) {
    res.status(err.status || 500);
    res.render('error', {
      message: err.message,
      error: err
    });
  });
}

// production error handler
// no stacktraces leaked to user
app.use(function(err, req, res, next) {
  res.status(err.stats || 500);
  res.render('error', {
    message: err.message,
    error: {}
  });
});
*/

module.exports = app;
