const chai = require('chai');
const chaiHttp = require('chai-http');
const app = require('../app'); // Import your Express app
const expect = chai.expect;

chai.use(chaiHttp);

describe('Authentication Routes', () => {
    // Test the GET /login route
    describe('GET /login', () => {
        it('should render the login page', (done) => {
            chai.request(app)
                .get('/login')
                .end((err, res) => {
                    expect(res).to.have.status(200);
                    expect(res.text).to.include('Connexion');
                    done();
                });
        });
    });

    // Test the POST /login route
    describe('POST /login', () => {
        it('should authenticate a user with valid credentials', (done) => {
            chai.request(app)
                .post('/login')
                .send({ username: 'hajar', password: 'hajar' })
                .end((err, res) => {
                    if (err) {
                        console.error(err); // Log the error
                    }
                    expect(res).to.have.status(200);
                    done();
                });
        });
        it('should reject invalid credentials', (done) => {
            chai.request(app)
                .post('/login')
                .send({ username: 'invalidUser', password: 'invalidPassword' })
                .end((err, res) => {
                    expect(res).to.have.status(400);
                    expect(res.text).to.include('Invalid username or password');
                    done();
                });
        });
    });

});

