var mongoose = require('mongoose');
var Schema = mongoose.Schema;
var passportLocalMongoose = require('passport-local-mongoose');

var userSchema = new Schema({
    username: { type: String, required: true },
    password: { type: String, required: true },
    isAgent: { type: Boolean, default: false }
});

userSchema.plugin(passportLocalMongoose);

userSchema.methods.validPassword = function(password) {
    return this.password === password;
};

const announcementSchema = new Schema({
    title: { type: String, required: true },
    propertyType: { type: String, required: true },
    publicationStatus: { type: String, required: true },
    propertyStatus: { type: String, required: true },
    description: { type: String, required: true },
    price: { type:Number, required: true },
    availabilityDate: { type: Date, required: true },
    photos:{ type: [String] },
    userName: { type: String, required: true }
});

const User = mongoose.model('User', userSchema);
const Announcement = mongoose.model('Announcement', announcementSchema);

module.exports = {
    User: User,
    Announcement: Announcement
};

