import * as SQLite from 'expo-sqlite';

const db = SQLite.openDatabase('cart.db');

db.transaction((tx) => {
  console.log('Inside transaction, before creating table');

  const createItemsTablePromise = new Promise((resolve, reject) => {
    tx.executeSql(
      'CREATE TABLE IF NOT EXISTS items (id INTEGER PRIMARY KEY, name TEXT NOT NULL, price REAL NOT NULL, quantity INTEGER NOT NULL)',
      [],
      () => {
        console.log('Table "items" created successfully');
        resolve();
      },
      (error) => {
        reject(error);
      }
    );
  });

  const createHistoryTablePromise = new Promise((resolve, reject) => {
    tx.executeSql(
      'CREATE TABLE IF NOT EXISTS history (id INTEGER PRIMARY KEY, name TEXT NOT NULL, price REAL NOT NULL, date TEXT NOT NULL)',
      [],
      () => {
        console.log('Table "history" created successfully');
        resolve();
      },
      (error) => {
        reject(error);
      }
    );
  });

  Promise.all([createItemsTablePromise, createHistoryTablePromise]).then(() => {
    console.log('Inside transaction, after creating both tables');
  });
});

export default db;
