import { StripeProvider } from '@stripe/stripe-react-native';
import Constants from 'expo-constants';
import { NavigationContainer } from '@react-navigation/native';
import { createNativeStackNavigator } from '@react-navigation/native-stack';
import CheckoutScreen from './CheckoutScreen';
import ScanScreen from './screens/ScanScreen';
import CartScreen from './screens/CartScreen';

const Stack = createNativeStackNavigator();
const stripePK = Constants.manifest.extra.stripePK;

export default function App() {
  return (
    <StripeProvider publishableKey={stripePK}>
      <NavigationContainer>
        <Stack.Navigator initialRouteName="ScanScreen">
          <Stack.Screen name="CartScreen" component={CartScreen} />
          <Stack.Screen name="ScanScreen" component={ScanScreen} />
          <Stack.Screen name="Checkout" component={CheckoutScreen} />
        </Stack.Navigator>
      </NavigationContainer>
    </StripeProvider>
  );
}
