function Car(image, make, model, description, price, category, year, mileage, extras) {
	if (arguments.length != 9)
		throw "ArgumentCountException";
	this.image = image;
	this.make = make;
	this.model = model;
	this.description = description;
	this.price = price;
	this.category = category;
	this.year = year;
	this.mileage = mileage;
	this.extras = extras;
}

Car.prototype.generateImage = function(elt) {
	if (elt instanceof HTMLElement) {
		const img = new Image();
		img.src = this.image;
		img.alt = this.make + " " + this.model;
		img.classList.add("card-img-top");
		elt.appendChild(img);
	}
}

Car.prototype.generateExtras = function(elt) {
	if (elt instanceof HTMLElement) {
		const ul = document.createElement("ul");
		if (this.extras) {
			this.extras.forEach(function(item) {
				const li = document.createElement("li");
				li.innerText = item.name + " - " + item.price + "€";
				ul.appendChild(li);
			});
		}
		elt.appendChild(ul);
	}
}