package fr.univlehavre.projet.entree;

import org.junit.jupiter.api.Test;

import static org.junit.jupiter.api.Assertions.*;

public class PersonneTest {

	@Test
	void testToStringInfoComplet() {
		Personne p = new Personne("Dumbledore", new String[]{"Albus", "Perceval", "Wulfric", "Brian"}, GENRE.HOMME,
			            null, "Directeur", new Societe("Ecole de sorcellerie Poudlard"));

		assertEquals("M. Albus Perceval Wulfric Brian Dumbledore\n" +
			"  - Société : Ecole de sorcellerie Poudlard\n" +
			"  - Fonction: Directeur", p.toString(Presentation.COMPLET, Sens.PRENOMS_NOMS));

	}

	@Test
	void testToStringInfoAbrege() {
		Personne p = new Personne("Potter", new String[]{"Harry", "Jammes"}, GENRE.HOMME,
			null, "Eleve", new Societe("Ecole de sorcellerie Poudlard"));

		assertEquals("H. J. Potter", p.toString(Presentation.ABREGE, Sens.PRENOMS_NOMS));

	}

	@Test
	void testToStringInfoSimple() {
		Personne p = new Personne("Dumbledore", new String[]{"Albus", "Perceval", "Wulfric", "Brian"}, GENRE.HOMME,
			null, "Directeur", new Societe("Ecole de sorcellerie Poudlard"));

		assertEquals("M. Albus P. W. B. Dumbledore (Ecole de sorcellerie Poudlard)",
			p.toString(Presentation.SIMPLE, Sens.PRENOMS_NOMS));

	}

	@Test
	void testToStringInfoSansPresentation() {
		Personne p = new Personne("Dumbledore", new String[]{"Albus", "Perceval", "Wulfric", "Brian"}, GENRE.HOMME,
			null, "Directeur", new Societe("Ecole de sorcellerie Poudlard"));

		assertEquals("M. Albus Perceval Wulfric Brian Dumbledore\n" +
				"  - Société : Ecole de sorcellerie Poudlard\n" +
				"  - Fonction: Directeur", p.toString(null, Sens.PRENOMS_NOMS));

	}

	@Test
	void testToStringInfoSansSens() {
		Personne p = new Personne("Dumbledore", new String[]{"Albus", "Perceval", "Wulfric", "Brian"}, GENRE.HOMME,
			null, "Directeur", new Societe("Ecole de sorcellerie Poudlard"));

		assertEquals("M. Albus Perceval Wulfric Brian Dumbledore\n" +
				"  - Société : Ecole de sorcellerie Poudlard\n" +
				"  - Fonction: Directeur", p.toString(Presentation.COMPLET, null));

	}

	@Test
	void testToStringInfoSensInverse() {
		Personne p = new Personne("Dumbledore", new String[]{"Albus", "Perceval", "Wulfric", "Brian"}, GENRE.HOMME,
			null, "Directeur", new Societe("Ecole de sorcellerie Poudlard"));

		assertEquals("M. Dumbledore Albus Perceval Wulfric Brian\n" +
				"  - Société : Ecole de sorcellerie Poudlard\n" +
				"  - Fonction: Directeur", p.toString(Presentation.COMPLET, Sens.NOM_PRENOMS));

	}
}
