package fr.univlehavre.projet.carnet;

import fr.univlehavre.projet.entree.Entree;
import fr.univlehavre.projet.entree.Presentation;
import fr.univlehavre.projet.entree.Sens;
import fr.univlehavre.projet.entree.Societe;
import org.junit.jupiter.api.Test;

import java.io.File;
import java.io.IOException;

import static org.junit.jupiter.api.Assertions.*;

class CarnetTest {

	@Test
	void testLectureFichier() throws IOException {
		Carnet c = new Carnet();

		ClassLoader classLoader = getClass().getClassLoader();
		File file = new File(classLoader.getResource("carnet.csv").getFile());

		c.lectureFichier(file.getAbsolutePath());

		assertEquals(4, c.getCompteurEntrees());
	}

	@Test
	void testLectureFichierToutesEntrees() throws IOException {
		Carnet c = new Carnet();

		ClassLoader classLoader = getClass().getClassLoader();
		File file = new File(classLoader.getResource("carnet.csv").getFile());

		c.lectureFichier(file.getAbsolutePath());

		assertEquals("Ecole de sorcellerie Poudlard", c.getEntree(0).toString(null, null));
		assertEquals("M. Albus P. W. B. Dumbledore (Ecole de sorcellerie Poudlard)",
			c.getEntree(1).toString(Presentation.SIMPLE, Sens.PRENOMS_NOMS));
		assertEquals("M. Harry J. Potter (Ecole de sorcellerie Poudlard)",
			c.getEntree(2).toString(Presentation.SIMPLE, Sens.PRENOMS_NOMS));
		assertEquals("Mme Ginny Weasley (Ecole de sorcellerie Poudlard)",
			c.getEntree(3).toString(Presentation.SIMPLE, Sens.PRENOMS_NOMS));

	}
}
