package fr.univlehavre.projet.entree;

import java.awt.datatransfer.StringSelection;

public class Personne implements Entree {

	private String nom;

	private String[] prenoms;

	private GENRE genre;

	private Personne conjoint;

	private String fonction;

	private Societe societe;


	public Personne (String nom, String[] prenoms, GENRE genre, Personne conjoint, String fonction, Societe societe){
		this.nom      = nom;
		this.prenoms  = prenoms;
		this.genre    = genre;
		this.conjoint = conjoint;
		this.fonction = fonction;
		this.societe  = societe;
	}


	@Override
	public String toString(Presentation p, Sens s) {
		String sRet = "";
		String sGenre = "";
		String infoComplémentaire = "";

		if (p == null)
			p = Presentation.COMPLET;

		switch (p) {
			case ABREGE: {
				if (prenoms.length > 1)
					for (String prenon : prenoms)
						sRet += prenon.substring(0, 1) + ". ";

				else
					sRet += prenoms[0];
			};break;

			case SIMPLE:{
				if(genre.equals(GENRE.FEMME))
					sGenre+="Mme ";
				else
					sGenre += "M. ";

				sRet += prenoms[0]+ " ";
				if (prenoms.length > 1) {
					for (int i = 1; i<prenoms.length; i++)
						sRet += prenoms[i].substring(0, 1) + ". ";
				}

				if(societe != null)
					infoComplémentaire += " (" + societe.toString(null, null) + ")";
			};break;

			default:{
				if(genre.equals(GENRE.FEMME))
					sGenre += "Mme ";
				else
					sGenre += "M. ";

				sRet += prenoms[0]+ " ";
				if (prenoms.length > 1) {
					for (int i = 1; i<prenoms.length; i++)
						sRet += prenoms[i] + " ";
				}


				if(societe != null)
					infoComplémentaire += "\n  - Société : " + societe.toString(null, null);

				infoComplémentaire += "\n  - Fonction: " + fonction;

			};break;
		}


		if (s != null && s.equals(Sens.NOM_PRENOMS))
			sRet = nom + " " + sRet.replace(prenoms[prenoms.length-1] + " ", prenoms[prenoms.length-1]);
		else
			sRet += nom;

		if (!infoComplémentaire.equals(""))
			sRet += infoComplémentaire;

		return sGenre + sRet;
	}

	@Override
	public boolean recherche(String s) {
		return false;
	}
}
