package fr.univlehavre.projet.carnet;

import fr.univlehavre.projet.entree.Entree;
import fr.univlehavre.projet.entree.GENRE;
import fr.univlehavre.projet.entree.Personne;
import fr.univlehavre.projet.entree.Societe;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.GenericArrayType;

public class Carnet {

	private Entree[] entrees;
	private Entree[] selectionnees;
	private int      compteurEntrees;
	private int      compteurSelectionnees;

	public Carnet (){
		entrees       = new Entree[100];
		selectionnees = new Entree[100];

		compteurEntrees = compteurSelectionnees = 0;
	}



	public void lectureFichier(String nomFichier) throws IOException {

		String[] contenueLigne;

		FileReader fr = new FileReader(nomFichier);
		BufferedReader br = new BufferedReader(fr);

		GENRE genre;
		Personne personne;
		Societe societe;

		for (String ligne = br.readLine(); ligne != null; ligne = br.readLine()){

			contenueLigne = ligne.split(";");

			if (contenueLigne[1].equals("SOCIETE")) {
				ajouterEntree(new Societe(contenueLigne[2]));
			}
			else if (contenueLigne[1].equals("PERSONNE")) {

				if (contenueLigne[4].equals("F"))
					genre = GENRE.FEMME;
				else
					genre = GENRE.HOMME;

				if(contenueLigne.length >5 && !contenueLigne[5].equals("") &&
					Integer.parseInt(contenueLigne[5]) <= compteurEntrees)
					personne = (Personne) entrees[Integer.parseInt(contenueLigne[5])-1];
				else
					personne = null;

				if(contenueLigne.length >6 && !contenueLigne[6].equals("") &&
					Integer.parseInt(contenueLigne[6]) <= compteurEntrees)
					societe = (Societe) entrees[Integer.parseInt(contenueLigne[6])-1];
				else
					societe = null;


				ajouterEntree(new Personne(contenueLigne[3], contenueLigne[2].split(","), genre,
					personne, contenueLigne[7], societe));

			}


		}
	}

	public Entree getEntree(int id){
		return entrees[id];
	}

	public void ajouterEntree(Entree entree){
		this.entrees[this.compteurEntrees++] = entree;
	}


	public int getCompteurEntrees() {
		return compteurEntrees;
	}
}
