# Projet *Standard* <small>(TP d'integration)</small> [![pipeline status](https://www-apps.univ-lehavre.fr/forge/rc150846/projet-standard/badges/master/pipeline.svg)](https://www-apps.univ-lehavre.fr/forge/rc150846/projet-standard/commits/master) [![coverage report](https://www-apps.univ-lehavre.fr/forge/rc150846/projet-standard/badges/master/coverage.svg)](https://www-apps.univ-lehavre.fr/forge/rc150846/projet-standard/commits/master)

- Année : **M1 iWOCS**
- Matière: *matière*
- TP : *TP d'integration*

## Auteur(s)

Ramos Corentin (Alice & Bob)

## User Story

- *Quels sont les fonctionnalités apportées par ce projet ?*

- On veut réaliser un simple modèle objet en Java qui permet de gérer un carnet d’adresses.
   
   Un carnet d’adresses est constitué d’entrées qui peuvent représenter des personnes ou des sociétés. Les informations et la présentation sont différentes s’il s’agis d’une personne ou d’une société.
   
   Une méthode utilitaire permet de lire les contacts à partir d’un fichier texte.
   
   On peut faire des recherches sur le carnet et sélectionner des contacts pour les afficher.
   
   L’affichage se fait en choisissant :
   
   l’ordre lexicographique (croissant ou décroissant),
   le sens d’affichage (nom ou prénom) et
   le mode présentation (abrégé, simple ou complet).
   En plus des méthodes indiquées, toutes les classes possèdent des accesseurs pour leurs champs privés. Le modèle objet est le suivant.

## Configuration du projet

Pour obtenir les informations de couverture de code des tests dans la forge, il convient de configurer le champ "*Test Coverage parsing*" dans "*Settings*" -> "*CI/CD*" -> "*General pipelines*"  avec la valeur : `\d+.\d+ \% covered`

Il faut également mettre à jour le nom du projet dans le fichier de configuration `pom.xml` dans la section `<artifactId>`.

## Projet de base

Ce projet est une base pour la réalisation de TP et projets dans différentes matières en informatique.

Ses principales fonctionnalités sont :

- Gestion de la compilation et des dépendances avec Maven (on peut utiliser [Maven Wrapper](https://github.com/takari/maven-wrapper) et la commande `mvnw` pour s'assurer de la compatibilité)
- Framework de tests configuré pour tester les fonctionnalités du projet avec JUnit (voir les exemple dans `src/test/...`).
- Exécution des tests avec maven `./mvnw test`
- Intégration continue avec GitLab (voir fichier `.gitlab-ci.yaml`)


## Utilisation

*Comment utiliser ce projet ?*

En utilisant maven on peut compiler et exécuter les tests du projet.

```sh
./mvnw clean compile test
```

---

This template is based on the  [`junit5-jupiter-starter-maven`](https://github.com/junit-team/junit5-samples/tree/r5.3.0/junit5-jupiter-starter-maven) project demonstrator.

Please note that this project uses the [Maven Wrapper](https://github.com/takari/maven-wrapper).
Thus, to ensure that the correct version of Maven is used, invoke `mvnw` instead of `mvn`.
