package fr.univlehavre.projet.entree;

import java.awt.datatransfer.StringSelection;

public class Personne implements Entree {

	private String nom;

	private String[] prenoms;

	private GENRE genre;

	private Personne conjoint;

	private String fonction;


	public Personne (String nom, String[] prenoms, GENRE genre, Personne conjoint, String fonction){
		this.nom = nom;
		this.prenoms = prenoms;
		this.genre = genre;
		this.conjoint = conjoint;
		this.fonction = fonction;
	}


	@Override
	public String toString(Presentation p, Sens s) {
		String sRet = "";
		String infoComplémentaire = "";

		switch (p) {
			case ABREGE: {
				if (prenoms.length > 1)
					for (String prenon : prenoms)
						sRet += prenon.substring(0, 1) + ". ";

				else
					sRet += prenoms[0];
			};break;

			case SIMPLE:{
				if(genre.equals(GENRE.FEMME))
					sRet+="Mme ";
				else
					sRet += "M. ";

				if (prenoms.length > 1)
					for (String prenon : prenoms)
						sRet += prenon.substring(0, 1) + ". ";

				else if (prenoms.length>0)
					sRet += prenoms[0];

			};break;

			case COMPLET:{
				if(genre.equals(GENRE.FEMME))
					sRet+="Mme ";
				else
					sRet += "M. ";

				if (prenoms.length > 1) {
					sRet += prenoms[0] + " ";
					for (int i = 1; i<prenoms.length; i++)
						sRet += prenoms[i].substring(0, 1) + ". ";
				}
				else if (prenoms.length>0)
					sRet += prenoms[0];

				infoComplémentaire += " - Fonction : " + fonction;

			};break;
		}


		if (s.equals(Sens.NOM_PRENOMS))
			sRet = nom + sRet;
		else
			sRet += nom;

		return sRet + "\n" + infoComplémentaire;
	}

	@Override
	public boolean recherche(String s) {
		return false;
	}
}
