import { ConnectButton } from '@rainbow-me/rainbowkit';
import type { NextPage } from 'next';
import Head from 'next/head';
import NFTGallery from '../components/NFTGallery';

const Home: NextPage = () => {
  return (
    <>
      <Head>
        <title>RainbowKit App</title>
        <meta
          content="Generated by @rainbow-me/create-rainbowkit"
          name="description"
        />
        <link href="/favicon.ico" rel="icon" />
      </Head>

      <header className="p-2 bg-lime-700 flex justify-end">
        <ConnectButton />
      </header>
      <main>
        <NFTGallery/>
      </main>
      <footer className="text-center py-5">
        NFT Raoul DUFY &copy; 2025
      </footer>
    </>
  );
};

export default Home;
