const { ethers } = require("hardhat");
const { buildModule } = require("@nomicfoundation/hardhat-ignition/modules");

module.exports = buildModule("DufyNFTModule", (m) => {
  // Déployer le contrat DufyNFT
  const nftContract = m.contract("DufyNFT", []);

  // Données des NFTs à mint
  const nftsData = [
    { tokenURI: "bafkreidhjka7zk33j56eyhebzhjuhwrgy3ilploxaofzkv24pl2oib7434", price: ethers.parseEther("1"), royaltyFee: 750 },
    { tokenURI: "bafkreicp3koc6cgybjr355ucgg3z26657zsvxfuyugyodaz76k3wh35fca", price: ethers.parseEther("2"), royaltyFee: 750 },
    { tokenURI: "bafkreicergmuw7h3cma7r2gn6z722b2entpft4y3q452z6ylkalt4tarai", price: ethers.parseEther("4"), royaltyFee: 650 },
    { tokenURI: "bafkreie3gw7wj5r6eodljghloaakijdrmcduth7afwu3bp4dif5edi3knu", price: ethers.parseEther("6"), royaltyFee: 570 },
    { tokenURI: "bafkreieuenwafbt4qpykm6lffsikorl2mtgkf75vwfyqgm2aqfsxjzqhjq", price: ethers.parseEther("3"), royaltyFee: 170 }
  ];

  async function mintAllNFTs() {
    const [owner] = await ethers.getSigners();
    
    nftsData.forEach((nftsData, index)=>{
      const { tokenURI, price, royaltyFee } = nftsData;

      const fingerprint = ethers.id(`${index}-${tokenURI}`);

      console.log(`Minting du NFT ${index} : URI ${tokenURI}, empreinte ${fingerprint}, prix ${price.toString()}GWEI et royalties ${royaltyFee / 100}%`);

      const uniqueId = `mintNFT_${index}`;
      
      m.call(nftContract, "mintNFT", [owner.address, tokenURI, fingerprint, price, royaltyFee], { id: uniqueId });
    })
  }

  mintAllNFTs();

  return { nftContract };
});
