import Head from "next/head";
import { useEffect, useState } from "react";
import Graph2 from "./graph2";
import Graph1 from "./graph1";

const Graphiques = () => {
    // Load the admin client-side
    const [showGraph, setShowGraph] = useState("");

    return (
        <>
            <Head>
                <title>Graphique</title>
            </Head>

            <select name="graphSelector" onChange={ev => setShowGraph(ev.target.value)}>
                <option value="">None</option>
                <option value="Graphe 1">Graphe 1</option>
                <option value="Graphe 2">Graphe 2</option>
            </select>

            {
                {
                    "Graphe 1":<Graph1 />,
                    "Graphe 2":<Graph2 />,
                    "": <div></div>
                }[showGraph]
            }
        </>
    );
};
export default Graphiques;
