/**
 * Fonction dessinant l'axe des abscisses
 * @param param0 
 * @returns 
 */
export function AxisX({ticks, transform, dateFormat}: { ticks:{ value: any, xOffset: number }[], transform: string, dateFormat: Intl.DateTimeFormatOptions }) {
    return (
        <g
            key="xAxis"
            transform={transform}
        >
            {ticks.map(({ value, xOffset }) => (
                <g
                    key={value.toISOString()}
                    transform={`translate(${xOffset}, 0)`}
                >
                    <line
                        y2="6"
                        stroke="currentColor"
                    />
                    <text
                        key={value.toISOString()}
                        style={{
                            fontSize: "10px",
                            textAnchor: "middle",
                            transform: "translateY(20px)"
                        }}>
                        {dateFormat ? new Intl.DateTimeFormat('fr-FR', dateFormat).format(value) : value}
                    </text>
                </g>
            ))}
            {(ticks.length>0)?(
                <g>
                    <line 
                        x1="0"
                        x2={ticks[ticks.length-1].xOffset}
                        stroke="currentColor"
                    />
                </g>
            ):<g />}
            
        </g>
    )
}

/**
 * Fonction dessinant l'axe des ordonnées
 * @param param0 
 * @returns 
 */
export function AxisY({ticks, transform, textLabel}: { ticks:{ value: any, yOffset: number }[], transform: string, textLabel:any}){
    return (
        <g
            key="yAxis"
            transform={transform}
        >
            {(ticks.length>0)?(
                <text
                    style={{
                        fontSize: "26px",
                        textAnchor: "middle",
                        transform: `translate(-85px,${ticks[ticks.length-1].yOffset/2-55}px)`
                    }}
                >
                    {textLabel}
                </text>
            ):<text />}
            {ticks.map(({ value, yOffset }) => (
                <g
                    key={value}
                    transform={`translate(-6, ${yOffset})`}
                >
                    <line
                        x2="6"
                        stroke="currentColor"
                    />
                    <text
                        key={value}
                        style={{
                            fontSize: "10px",
                            textAnchor: "middle",
                            transform: "translateX(-10px)"
                        }}>
                        {value}
                    </text>
                </g>
            ))}
            {(ticks.length>0)?(
                <g>
                    <line 
                        y1="0"
                        y2={ticks[ticks.length-1].yOffset}
                        stroke="currentColor"
                    />
                </g>
            ):<g />}
        </g>
    )
}