<?php

namespace App\Entity;

use ApiPlatform\Metadata\ApiResource;
use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\Validator\Constraints as Assert;

#[ApiResource]
#[ORM\Entity]
class Sale
{
    #[ORM\Id]
    #[ORM\Column(type: 'integer')]
    #[ORM\GeneratedValue]
    private ?int $id = null;

    #[ORM\Column(type: 'integer')]
    #[Assert\Range(min: 0.0)]
    public float $value = 0.0;

    #[ORM\Column(type: 'integer')]
    #[Assert\Range(min: 0)]
    public int $code_departement = 0;

    #[ORM\Column]
    #[Assert\NotBlank]
    public string $region = '';

    #[ORM\Column(type: 'integer')]
    #[Assert\Range(min: 0)]
    public int $surface = 0;
    
    #[ORM\Column]
    #[Assert\NotNull]
    public ?\DateTimeImmutable $date = null;

    public function getId(): ?int
    {
        return $this->id;
    }
}
