<?php

namespace App\DataFixtures;

use Doctrine\Bundle\FixturesBundle\Fixture;
use Doctrine\Persistence\ObjectManager;
use App\Entity\Sale;

class SaleFixtures extends Fixture
{
    const ID_VALUE = 10;
    const ID_DEPARTEMENT = 18;
    const ID_SURFACE = 42;
    const ID_DATE = 8;
    /** vente, échange, etc. Sert comme filtre */
    const ID_NATURE = 9;
    /** maison, appartement, etc. Sert comme filtre */
    const ID_TYPE = 36;

    public function load(ObjectManager $manager): void
    {
        ini_set('memory_limit', '8192M');
        $files = ['valeursfoncieres-2021.txt','valeursfoncieres-2020.txt','valeursfoncieres-2019.txt','valeursfoncieres-2018.txt'];
        foreach ($files as $file) { 
            echo "Début du traitement de ".$file."\n";
            $row = 0;
            if (($handle = fopen('data/'.$file, "r")) !== FALSE) {
                while (($data = fgetcsv($handle, 1000, "|")) !== FALSE) {
                    $row++;
                    if($row == 1 ||
                        $data[self::ID_NATURE] !== 'Vente' || 
                        $data[self::ID_TYPE] !== 'Maison' && $data[self::ID_TYPE] !== 'Appartement'){
                        continue;
                    }
                    $manager->persist(self::manageSale($data));

                    if($row % 10000 == 0){
                        $manager->flush();
                        $manager->clear();
                    }
                }
                fclose($handle);
            }
            echo $file." traité.\n";
        }
    }

    private function manageSale($data): Sale
    {
        $sale = new Sale();
        $sale->value = (float) $data[self::ID_VALUE];
        $sale->code_departement = (int) $data[self::ID_DEPARTEMENT];
        // TODO code_departement -> nom région
        $sale->surface = (int) $data[self::ID_SURFACE];
        $sale->date = \DateTimeImmutable::createFromFormat('d/m/Y', $data[self::ID_DATE]);
        return $sale;
    }
}