export const resizeGraph = (divId: string, widthCallback: (width: number) => void, heightCallback?: (height: number) => void) => {
    const div = document.querySelector<HTMLDivElement>(`#${divId}`);
    if (div) {
        if(widthCallback)
            widthCallback(div.offsetWidth);
        if(heightCallback)
            heightCallback(div.offsetHeight);
    }
}