import {
    render,
    screen,
    cleanup,
    waitFor,
    fireEvent
} from '@testing-library/react'
import '@testing-library/jest-dom'
import fetch from 'node-fetch';
import {act} from "react-dom/test-utils";
import Series from "../pages/series";
import {ApiService} from "../components/d3js/ApiService";

const items = [
    {date: '2017-12-31', value: 363},
    {date: '2018-01-31', value: 375},
    {date: '2018-02-28', value: 391},
    {date: '2018-03-31', value: 404},
    {date: '2018-04-30', value: 387},
    {date: '2018-05-31', value: 400},
    {date: '2018-06-30', value: 382},
    {date: '2018-07-31', value: 383},
    {date: '2018-08-31', value: 389},
    {date: '2018-09-30', value: 391},
    {date: '2018-10-31', value: 374},
    {date: '2018-11-30', value: 457},
    {date: '2018-12-31', value: 458},
    {date: '2019-01-31', value: 388},
    {date: '2019-02-28', value: 395},
    {date: '2019-03-31', value: 436},
    {date: '2019-04-30', value: 375},
    {date: '2019-05-31', value: 393},
    {date: '2019-06-30', value: 446},
    {date: '2019-07-31', value: 392},
    {date: '2019-08-31', value: 394},
    {date: '2019-09-30', value: 414},
    {date: '2019-10-31', value: 409},
    {date: '2019-11-30', value: 475},
    {date: '2019-12-31', value: 400},
    {date: '2020-01-31', value: 394},
    {date: '2020-02-28', value: 420},
    {date: '2020-03-31', value: 418},
    {date: '2020-04-30', value: 410},
    {date: '2020-05-31', value: 422},
    {date: '2020-06-30', value: 437},
    {date: '2020-07-31', value: 388},
    {date: '2020-08-31', value: 400},
    {date: '2020-09-30', value: 405},
    {date: '2020-10-31', value: 361},
    {date: '2020-11-30', value: 443},
    {date: '2020-12-31', value: 415},
    {date: '2021-01-31', value: 410},
    {date: '2021-02-28', value: 375},
    {date: '2021-03-31', value: 435},
    {date: '2021-04-30', value: 459},
    {date: '2021-05-31', value: 439},
    {date: '2021-06-30', value: 511},
    {date: '2021-07-31', value: 442},
    {date: '2021-08-31', value: 444},
    {date: '2021-09-30', value: 450},
    {date: '2021-10-31', value: 433},
    {date: '2021-11-30', value: 513}
]

describe('Tests sur le graphe du prix de vente moyen du mètre carré', () => {
    afterEach(() => {
        jest.clearAllMocks()
        cleanup();
    })
    describe('Tests sans données', () => {
        beforeEach(() => {
            jest.spyOn(ApiService, "getSeries").mockReturnValue(Promise.resolve([]));
        })
        test('Page de base', async () => {
            act(() => {
                render(<Series />)
            })
            await waitFor(() => {
                const spinner = screen.getByTestId("spinner");
                expect(spinner).toBeInTheDocument();
            })
        })
    })
    describe('Tests avec des données', () => {
        beforeEach(() => {
            jest.spyOn(ApiService, "getSeries").mockReturnValue(Promise.resolve(items));
        })
        test('Page de base', async () => {
            act(() => {
                render(<Series />)
            })
            await waitFor(() => {
                for(let item of items){
                    let itemG = screen.getByTestId(`data:${item.date}T00:00:00.000Z`);
                    expect(itemG).toBeInTheDocument();
                }
            })
        })
    })
})