import '@testing-library/jest-dom'
import {ApiService} from "../components/d3js/ApiService";

describe('Tests sur le graphe du nombre de ventes', () => {
    afterEach(() => {
        global.fetch.mockClear()
        delete global.fetch
    })
    describe('Regions', () => {
        const items = [
            {region: "Bretagne", percentage: 5},
            {region: "Nouvelle Aquitaine", percentage: 22},
            {region: "Occitanie", percentage: 16},
            {region: "Centre Val de Loire", percentage: 8},
            {region: "Normandie", percentage: 11.5},
            {region: "Ile de France", percentage: 13},
            {region: "Grand Est", percentage: 12}
        ]
        beforeEach(() => {
            global.fetch = jest.fn().mockImplementation(() => Promise.resolve({
                json: () => Promise.resolve({data: {regions: items}})
            }))
        })
        test('Récupération des données', async () => {
            const result = await ApiService.getRegions();
            expect(result).toEqual(items);
        })
        test('Test du cache', async () => {
            await ApiService.getRegions();

            global.fetch.mockClear()
            global.fetch = jest.fn().mockImplementation(() => Promise.resolve({
                json: () => Promise.resolve({data: {regions: []}})
            }))

            let result = await ApiService.getRegions();
            expect(result).toEqual(items);

            result = await ApiService.getRegions(2018);
            expect(result).toEqual([]);
        })
    })
    describe('Amounts', () => {
        const items = [
            {date: '2018-01-01', value: 50},
            {date: '2018-02-01', value: 40},
            {date: '2018-03-01', value: 45},
            {date: '2018-04-01', value: 35},
            {date: '2018-05-01', value: 55},
            {date: '2018-06-01', value: 30},
            {date: '2018-07-01', value: 120},
            {date: '2018-08-01', value: 155},
            {date: '2018-09-01', value: 130},
            {date: '2018-10-01', value: 200},
            {date: '2018-11-01', value: 250},
            {date: '2018-12-01', value: 20},
        ]
        beforeEach(() => {
            global.fetch = jest.fn().mockImplementation(() => Promise.resolve({
                json: () => Promise.resolve({data: {amounts: items}})
            }))
        })
        test('Récupération des données', async () => {
            const result = await ApiService.getAmounts(new Date("2018-01-01"), new Date("2019-01-01"), 'month');
            expect(result).toEqual(items);
        })
        test('Test du cache', async () => {
            await ApiService.getAmounts(new Date("2018-01-01"), new Date("2019-01-01"), 'month');

            global.fetch.mockClear()
            global.fetch = jest.fn().mockImplementation(() => Promise.resolve({
                json: () => Promise.resolve({data: {amounts: []}})
            }))

            let result = await ApiService.getAmounts(new Date("2018-01-01"), new Date("2019-01-01"), 'month');
            expect(result).toEqual(items);

            result = await ApiService.getAmounts(new Date("2018-01-01"), new Date("2019-01-01"), 'day');
            expect(result).toEqual([]);
        })
    })
    describe('Series', () => {
        const items = [
            {date: '2018-01-01', value: 50},
            {date: '2018-02-01', value: 40},
            {date: '2018-03-01', value: 45},
            {date: '2018-04-01', value: 35},
            {date: '2018-05-01', value: 55},
            {date: '2018-06-01', value: 30},
            {date: '2018-07-01', value: 120},
            {date: '2018-08-01', value: 155},
            {date: '2018-09-01', value: 130},
            {date: '2018-10-01', value: 200},
            {date: '2018-11-01', value: 250},
            {date: '2018-12-01', value: 20},
        ]
        beforeEach(() => {
            global.fetch = jest.fn().mockImplementation(() => Promise.resolve({
                json: () => Promise.resolve({data: {series: items}})
            }))
        })
        test('Récupération des données', async () => {
            const result = await ApiService.getSeries();
            expect(result).toEqual(items);
        })
    })
})