<?php

namespace App\DataFixtures;

use Doctrine\Bundle\FixturesBundle\Fixture;
use Doctrine\Persistence\ObjectManager;
use App\Entity\Sale;

class SaleTestFixtures extends AbstractSaleFixture
{
    protected function doLoad(ObjectManager $manager): void
    {        
        $persist = 0;
        if (($handle = fopen('data/tests.txt', "r")) !== FALSE) {
            while (($data = fgetcsv($handle, 1000, "|")) !== FALSE) {
                $manager->persist(self::manageSale($data));
                $persist++;
        	}
            fclose($handle);
			$manager->flush();
            $manager->clear();
        }
    }

	protected function manageSale($data): Sale
    {
        $sale = new Sale();
        $sale->type = $data[0];
        $sale->value = (int) $data[1];
        $sale->code_departement = (int) $data[2];
        $sale->region = $this->regions[$data[2]];
        $sale->surface = (int) $data[3];
        $sale->date = \DateTimeImmutable::createFromFormat('!d/m/Y', $data[4]);
        return $sale;
    }

    protected function getEnvironments()
    {
        return ['test'];
    }
}