<?php

namespace App\DataFixtures;

use Doctrine\Bundle\FixturesBundle\Fixture;
use Doctrine\Persistence\ObjectManager;
use App\Entity\Sale;

class SaleFixtures extends AbstractSaleFixture
{
    protected function doLoad(ObjectManager $manager): void
    {
        ini_set('memory_limit', '8192M');
        $files = ['valeursfoncieres-2021.txt','valeursfoncieres-2020.txt','valeursfoncieres-2019.txt','valeursfoncieres-2018.txt'];
        foreach ($files as $file) { 
            echo "Début du traitement de ".$file."\n";
            $persist = 0;
            if (($handle = fopen('data/'.$file, "r")) !== FALSE) {
                while (($data = fgetcsv($handle, 1000, "|")) !== FALSE) {
                    if(
                        $data[parent::ID_NATURE] !== 'Vente' ||
                        $data[parent::ID_SURFACE] == '' || $data[parent::ID_SURFACE] == '0' ||
                        $data[parent::ID_TYPE] !== 'Maison' && $data[parent::ID_TYPE] !== 'Appartement'){
                        continue;
                    }
                    $manager->persist(parent::manageSale($data));
                    $persist++;

                    if($persist % 10000 == 0){
                        echo $persist." lignes traités, flush\n";
                        $manager->flush();
                        $manager->clear();
                    }
                }
                fclose($handle);
                $manager->flush();
                $manager->clear();
            }
            echo $file." traité.\n";
        }
    }

    protected function getEnvironments()
    {
        return ['dev'];
    }
}