import "../styles/globals.css"
import "../styles/components.css"
import "bootstrap/dist/css/bootstrap.css"
import "bootstrap-icons/font/bootstrap-icons.css"
import Layout from "../components/common/Layout"
import type { AppProps } from "next/app"
import type { DehydratedState } from "react-query"
import MainPage from "../components/MainPage"

function MyApp({ Component, pageProps }: AppProps<{dehydratedState: DehydratedState}>) {
  return (
    <Layout dehydratedState={pageProps.dehydratedState}>
      <MainPage content={<Component {...pageProps} />} />
    </Layout>
  );
}

export default MyApp
