import React from "react";

export default function Spinner({ active, onDeactivate }: { active: boolean, onDeactivate?: () => void }) {
    if (active) {
        return (
            <div className="d-flex justify-content-center">
                <div className="spinner-border" role="status">
                    <span className="sr-only"></span>
                </div>
            </div>
        );
    } else {
        if (onDeactivate)
            onDeactivate();
    }
    return <></>;
}