import Link from "next/link";
import { useRouter } from "next/router";

const routes = [
  {
    to: "/series",
    name: "Prix de vente moyen du m²",
  },
  {
    to: "/amount",
    name: "Nombre de ventes",
  },
  {
    to: "/regions",
    name: "Répartition des ventes par région",
  },
];

const Sidebar = () => {
  const router = useRouter();

  return (
    <nav className="d-flex flex-column flex-shrink-0 p-3 border-end">
      <Link href="/">
        <a className="h2 text-reset text-decoration-none">Visualisations</a>
      </Link>
      <hr />
      <ul className="nav nav-pills flex-column mb-auto">
        {routes.map((route) => (
          <li key={route.to} className="nav-item">
            <Link href={route.to}>
              <a
                className={
                  router.pathname === route.to ? "nav-link active" : "nav-link"
                }
              >
                {route.name}
              </a>
            </Link>
          </li>
        ))}
      </ul>
    </nav>
  );
};

export default Sidebar;
