<?php

namespace App\State;

use ApiPlatform\Metadata\Operation;
use ApiPlatform\State\ProviderInterface;
use App\Entity\Sale;
use Doctrine\Persistence\ManagerRegistry;

class SeriesProvider implements ProviderInterface
{
    public function __construct(private ManagerRegistry $registry) {}
    
    public function provide(Operation $operation, array $uriVariables = [], array $context = []): object|array|null
    {
        return $this->registry->getRepository(Sale::class)
            ->getSeries();
    }
}
