<?php

namespace App\Resolver;

use ApiPlatform\GraphQl\Resolver\QueryCollectionResolverInterface;
use App\Entity\Sale;
use Doctrine\Persistence\ManagerRegistry;

final class SeriesResolver implements QueryCollectionResolverInterface
{

	public function __construct(private ManagerRegistry $registry) {}
	
	/**
	 * @param iterable<Sale> $collection
	 *
	 * @return iterable<Sale>
	 */
	public function __invoke(iterable $collection, array $context): iterable
	{
		// Query arguments are in $context['args'].

		return $this->registry->getRepository(Sale::class)
			->getSeries();
	}
}