<?php

namespace App\Resolver;

use ApiPlatform\GraphQl\Resolver\QueryCollectionResolverInterface;
use App\Entity\Sale;
use Doctrine\Persistence\ManagerRegistry;

final class RegionResolver implements QueryCollectionResolverInterface
{

	public function __construct(private ManagerRegistry $registry) {}
	
	/**
	 * @param iterable<Sale> $collection
	 *
	 * @return iterable<Sale>
	 */
	public function __invoke(iterable $collection, array $context): iterable
	{
		// Query arguments are in $context['args'].
		$year = $context['args']['year'] ?? 2021;

		return $this->registry->getRepository(Sale::class)
			->getRegions($year);
	}
}