<?php

namespace App\Repository;

use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\DBAL\Connection;
use Doctrine\Persistence\ManagerRegistry;
use App\Entity\Sale;

class SaleRepository extends ServiceEntityRepository {
	private Connection $connection;

	public function __construct(ManagerRegistry $registry) {
		parent::__construct($registry, Sale::class);
		$this->connection = $this->getEntityManager()->getConnection();
	}

	public function getSeries() {
		$result = $this->connection
			->prepare("select date_trunc('month', date) as date, cast(avg(value / surface) as int) as value from sale s where surface != 0 group by date_trunc('month', date)")
			->executeQuery();
		return $result->fetchAllAssociative();
	}

	public function getRegions($year){
		$result = $this->connection
			->prepare("select region, (sum_sales * 100 / SUM(sum_sales) OVER ()) as percentage from (select region, count(*) as sum_sales from sale where extract(year from date)=:year group by region) as q_sum group by q_sum.region, q_sum.sum_sales order by percentage desc limit 8");
		$result->bindValue('year', $year);
		return $result->executeQuery()->fetchAllAssociative();
	}

	public function getAmounts(string $groupby, string $dateStart, string $dateEnd) {
		$result = $this->connection
			->prepare("select date_trunc(:groupby, date) as date, count(*) as value from sale where date >= :dateStart and date < :dateEnd group by date_trunc(:groupby, date) order by date asc;");
		$result->bindValue('groupby', $groupby);
		$result->bindValue('dateStart', $dateStart);
		$result->bindValue('dateEnd', $dateEnd);
		return $result->executeQuery()->fetchAllAssociative();
	}
}