<?php

namespace App\Entity;

use ApiPlatform\Metadata\ApiResource;
use ApiPlatform\Metadata\GetCollection;
use ApiPlatform\Metadata\GraphQl\QueryCollection;
use App\Resolver\SeriesResolver;
use App\State\SeriesProvider;

#[ApiResource(operations: [
	new GetCollection()
], graphQlOperations: [
	new QueryCollection(
		resolver: SeriesResolver::class,
		read: false,
	)
], provider: SeriesProvider::class, paginationEnabled: false)]
class Series {
	public \DateTime $date;

	public float $value;
}