<?php

namespace App\Entity;

use ApiPlatform\Metadata\ApiResource;
use App\Repository\SaleRepository;
use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\Validator\Constraints as Assert;

#[ApiResource(operations: [])]
#[ORM\Entity(repositoryClass: SaleRepository::class)]
class Sale
{
    #[ORM\Id]
    #[ORM\Column(type: 'integer')]
    #[ORM\GeneratedValue]
    private ?int $id = null;

    #[ORM\Column]
    public string $type = '';

    #[ORM\Column(type: 'integer')]
    #[Assert\Range(min: 0)]
    public int $value = 0;

    #[ORM\Column(type: 'integer')]
    #[Assert\Range(min: 0)]
    public int $code_departement = 0;

    #[ORM\Column]
    public ?string $region = '';

    #[ORM\Column(type: 'integer')]
    #[Assert\Range(min: 0)]
    public int $surface = 0;

    #[ORM\Column]
    #[Assert\NotNull]
    public ?\DateTimeImmutable $date = null;

    public function getId(): ?int
    {
        return $this->id;
    }
}