<?php

namespace App\Entity;

use ApiPlatform\Metadata\ApiResource;
use ApiPlatform\Metadata\GetCollection;
use ApiPlatform\Metadata\GraphQl\QueryCollection;
use App\Resolver\AmountResolver;
use App\State\AmountProvider;

#[ApiResource(operations: [
	new GetCollection(
		uriTemplate: '/amounts/groupby={groupby}&dateStart={dateStart}&dateEnd={dateEnd}',
		requirements: [
			'groupby' => 'day|week|month|year',
			'dateStart' => '\d{4}-\d{2}-\d{2}',
			'dateEnd' => '\d{4}-\d{2}-\d{2}'
		])
], graphQlOperations: [
	new QueryCollection(
		resolver: AmountResolver::class,
		read: false,
		args: [
			'groupby' => ['type' => 'String!'],
			'dateStart' => ['type' => 'String!'],
			'dateEnd' => ['type' => 'String!']
		]
	)
], provider: AmountProvider::class, paginationEnabled: false)]
class Amount {
	public \DateTime $date;

	public float $value;
}