<?php

namespace App\DataFixtures;

use Doctrine\Bundle\FixturesBundle\Fixture;
use Doctrine\Persistence\ObjectManager;
use App\Entity\Sale;

class SaleFixtures extends Fixture
{
    const ID_VALUE = 10;
    const ID_DEPARTEMENT = 18;
    const ID_SURFACE = 42;   // Surface terrain
    const ID_DATE = 8;
    /** vente, échange, etc. Sert comme filtre */
    const ID_NATURE = 9;
    /** maison, appartement, etc. Sert comme filtre */
    const ID_TYPE = 36;

    private $regions = [];

    public function load(ObjectManager $manager): void
    {
        $fregions = fopen('data/regions.txt', "r");
        while(!feof($fregions)) {
            $tline = explode("\t", fgets($fregions));
            for ($i=0; $i < sizeof($tline); $i++) {
                if(sizeof($tline) > 2 && $tline[2])
                    $this->regions[$tline[0]] = substr($tline[2], 0, strlen($tline[2])-1);
            }
        }
        fclose($fregions);
        
        ini_set('memory_limit', '8192M');
        $files = ['valeursfoncieres-2021.txt','valeursfoncieres-2020.txt','valeursfoncieres-2019.txt','valeursfoncieres-2018.txt'];
        foreach ($files as $file) { 
            echo "Début du traitement de ".$file."\n";
            $persist = 0;
            if (($handle = fopen('data/'.$file, "r")) !== FALSE) {
                while (($data = fgetcsv($handle, 1000, "|")) !== FALSE) {
                    if(
                        $data[self::ID_NATURE] !== 'Vente' ||
                        $data[self::ID_SURFACE] == '' || $data[self::ID_SURFACE] == '0' ||
                        $data[self::ID_TYPE] !== 'Maison' && $data[self::ID_TYPE] !== 'Appartement'){
                        continue;
                    }
                    $manager->persist(self::manageSale($data));
                    $persist++;

                    if($persist % 10000 == 0){
                        echo $persist." lignes traités, flush\n";
                        $manager->flush();
                        $manager->clear();
                    }
                }
                fclose($handle);
                $manager->flush();
                $manager->clear();
            }
            echo $file." traité.\n";
        }
    }

    private function manageSale($data): Sale
    {
        $sale = new Sale();
        $sale->type = $data[self::ID_TYPE];
        $sale->value = (int) $data[self::ID_VALUE];
        $sale->code_departement = (int) $data[self::ID_DEPARTEMENT];
        $sale->region = $this->regions[$data[self::ID_DEPARTEMENT]];
        $sale->surface = (int) $data[self::ID_SURFACE];
        $sale->date = \DateTimeImmutable::createFromFormat('!d/m/Y', $data[self::ID_DATE]);
        return $sale;
    }
}